import * as fs from 'fs';
import * as path from 'path';

interface File {
  path: string;
  content: string;
}

class FileSystem {
  private files: File[];

  constructor() {
    this.files = [];
  }

  getFiles(): File[] {
    return this.files;
  }

  getFile(path: string): File | null {
    return this.files.find((file) => file.path === path);
  }

  createFile(path: string, content: string): void {
    const file: File = { path, content };
    this.files.push(file);
  }

  updateFile(path: string, content: string): void {
    const file = this.getFile(path);
    if (file) {
      file.content = content;
    }
  }

  deleteFile(path: string): void {
    this.files = this.files.filter((file) => file.path !== path);
  }
}

export { FileSystem };
