// Import required modules
import { Container } from 'inversify';
import { IController } from './controllers/controller.interface';
import { IUseCase } from './use-cases/use-case.interface';

// Create a container instance
const container = new Container();

// Register dependencies
container.bind<IController>('IController').to(Controller);
container.bind<IUseCase>('IUseCase').to(UseCase);

// Create an instance of the App class
export class App {
  private container: Container;

  constructor(container: Container) {
    this.container = container;
  }

  start(): void {
    // Start the application
  }
}