import { User } from '../entities/user.entity';

export class GetUserUseCase {
  private userRepository: UserRepository;

  constructor(userRepository: UserRepository) {
    this.userRepository = userRepository;
  }

  public async execute(id: string): Promise<User> {
    const user = await this.userRepository.findById(id);
    return user;
  }
}