import express, { Request, Response } from 'express';
import UserController from './controllers/UserController';
import UserService from './services/UserService';
import logger from './utils/logger';

const app = express();
app.use(express.json());
app.get('/users', async (req: Request, res: Response) => {
  const userService = new UserService(new UserRepository());
  const users = await userService.findAll();
  logger.info('Users retrieved successfully.');
  res.json(users);
});

app.listen(3000, () => {
  logger.info('Server listening on port 3000.');
});