# Clean Architecture Project

## Overview
This project follows a clean architecture approach, separating the application logic into layers.

## Directory Structure

### Client

* `src`: Client-side code
  * `components`: React components
  * `containers`: Container components
  * `services`: API services
  * `store`: Redux store
  * `utils`: Utility functions

### Server

* `src`: Server-side code
  * `controllers`: API controllers
  * `models`: Database models
  * `repositories`: Data access objects
  * `services`: Business logic services
  * `utils`: Utility functions

## Running the Application

### Client

1. Run `npm run build` to build the client-side code.
2. Run `npm start` to start the client-side development server.

### Server

1. Run `npm run build` to build the server-side code.
2. Run `npm start` to start the server.
