const express = require('express');
const router = express.Router();

const Fish = require('../models/Fish');

// GET all fish
router.get('/', async (req, res) => {
  try {
    const fish = await Fish.find().exec();
    res.json(fish);
  } catch (err) {
    res.status(500).json({ message: 'Error fetching fish' });
  }
});

// GET fish by ID
router.get('/:id', async (req, res) => {
  try {
    const fish = await Fish.findById(req.params.id).exec();
    if (!fish) {
      res.status(404).json({ message: 'Fish not found' });
    } else {
      res.json(fish);
    }
  } catch (err) {
    res.status(500).json({ message: 'Error fetching fish' });
  }
});

// POST create new fish
router.post('/', async (req, res) => {
  try {
    const fish = new Fish(req.body);
    await fish.save();
    res.json(fish);
  } catch (err) {
    res.status(500).json({ message: 'Error creating fish' });
  }
});

// PUT update fish
router.put('/:id', async (req, res) => {
  try {
    const fish = await Fish.findByIdAndUpdate(req.params.id, req.body, { new: true }).exec();
    if (!fish) {
      res.status(404).json({ message: 'Fish not found' });
    } else {
      res.json(fish);
    }
  } catch (err) {
    res.status(500).json({ message: 'Error updating fish' });
  }
});

// DELETE fish
router.delete('/:id', async (req, res) => {
  try {
    await Fish.findByIdAndRemove(req.params.id).exec();
    res.json({ message: 'Fish deleted' });
  } catch (err) {
    res.status(500).json({ message: 'Error deleting fish' });
  }
});

module.exports = router;