// src/components/FishList.tsx

import React from 'react';
import FishCard from './FishCard';

interface Fish {
  name: string;
  habitat: string;
  diet: string;
}

interface Props {
  fish: Fish[];
}

function FishList({ fish }: Props) {
  return (
    <div>
      {fish.map((fish) => (
        <FishCard key={fish.name} fish={fish} />
      ))}
    </div>
  );
}

export default FishList;
