// User controller
import { UserRepository } from '../infrastructure/repositories/UserRepository';

class UserController {
  private userRepository: UserRepository;

  constructor(userRepository: UserRepository) {
    this.userRepository = userRepository;
  }

  async saveUser(req: any, res: any): Promise<void> {
    const user = req.body;
    await this.userRepository.save(user);
    res.json(user);
  }

  async getAllUsers(req: any, res: any): Promise<void> {
    const users = await this.userRepository.findAll();
    res.json(users);
  }
}
