import { Container } from 'inversify';
import { Controller } from './controller';
import { Service } from './service';

export class Application {
  private container: Container;

  constructor(container: Container) {
    this.container = container;
  }

  listen(port: number, callback: () => void): void {
    const controller = this.container.get<Controller>('Controller');
    const service = this.container.get<Service>('Service');
    controller.start(service, port, callback);
  }
}