// server.js
const express = require('express');
const app = express();
const port = 3000;

app.get('/files', (req, res) => {
  const files = getFiles();
  res.json(files);
});

app.get('/files/:path', (req, res) => {
  const path = req.params.path;
  const file = getFile(path);
  if (file) {
    res.json(file);
  } else {
    res.status(404).send('File not found');
  }
});

app.listen(port, () => {
  console.log(`Server listening on port ${port}`);
});

function getFiles() {
  const files = [];
  const fs = require('fs');
  const dir = __dirname;
  const filesInDir = fs.readdirSync(dir);
  filesInDir.forEach((file) => {
    const filePath = `${dir}/${file}`;
    const stats = fs.statSync(filePath);
    if (stats.isFile()) {
      files.push({
        path: filePath,
        content: fs.readFileSync(filePath, 'utf8')
      });
    }
  });
  return files;
}

function getFile(path) {
  try {
    return {
      path,
      content: fs.readFileSync(path, 'utf8')
    };
  } catch (error) {
    return null;
  }
}