# Clean Architecture API

## Overview
This is a clean architecture API built with Node.js and Express.js.

## Routes
### GET /files
Returns a list of files in the server/src directory.

### GET /files/:path
Returns the content of a file at the specified path.

## Usage
To use this API, simply send a GET request to the /files endpoint with the desired path as a query parameter.

## Example
```bash
curl http://localhost:3000/files?path=src/server.js
```

## Response
```json
{
  "files": [
    {
      "path": "src/server.js",
      "content": "// server.js"
    }
  ]
}
```
