// Import required modules
import { UserRepository } from './UserRepository';
import { User } from '../core/entities/User';

// Define the UserRepository class
class UserRepository implements UserRepository {
  private users: User[];

  // Constructor
  constructor() {
    this.users = [];
  }

  // Get all users
  getAllUsers(): User[] {
    return this.users;
  }

  // Save a user
  saveUser(user: User): void {
    this.users.push(user);
  }
}

// Export the UserRepository class
export default UserRepository;