// Import required modules
import { Entity } from './Entity';

// Define the User entity
class User extends Entity {
  private id: string;
  private name: string;
  private email: string;

  // Constructor
  constructor(id: string, name: string, email: string) {
    super();
    this.id = id;
    this.name = name;
    this.email = email;
  }

  // Getters
  getId(): string {
    return this.id;
  }

  getName(): string {
    return this.name;
  }

  getEmail(): string {
    return this.email;
  }
}

// Export the User entity
export default User;