import User from '../models/user.model';

export default {
  async getAllUsers() {
    return await User.find().exec();
  },

  async getUserById(id) {
    return await User.findById(id).exec();
  },

  async createUser(data) {
    return await User.create(data);
  },

  async updateUser(id, data) {
    return await User.findByIdAndUpdate(id, data, { new: true }).exec();
  },

  async deleteUser(id) {
    return await User.findByIdAndRemove(id).exec();
  }
};
