// server/index.ts

import 'reflect-metadata';
import express from 'express';
import { createConnection } from 'typeorm';
import { AppDataSource } from './data-source';
import { AppRouter } from './router';

async function main() {
  await createConnection(AppDataSource);
  const app = express();
  const router = new AppRouter(app);
  app.listen(3000, () => {
    console.log('Server listening on port 3000.');
  });
}

main();
