import logger from '../utils/logger';
import userService from '../services/user.service';

export default {
  getAllUsers: async (req, res) => {
    try {
      const users = await userService.getAllUsers();
      res.json(users);
    } catch (err) {
      logger.error(err);
      res.status(500).send({ message: 'Internal Server Error' });
    }
  },

  getUserById: async (req, res) => {
    try {
      const id = req.params.id;
      const user = await userService.getUserById(id);
      res.json(user);
    } catch (err) {
      logger.error(err);
      res.status(500).send({ message: 'Internal Server Error' });
    }
  },

  createUser: async (req, res) => {
    try {
      const user = await userService.createUser(req.body);
      res.json(user);
    } catch (err) {
      logger.error(err);
      res.status(500).send({ message: 'Internal Server Error' });
    }
  },

  updateUser: async (req, res) => {
    try {
      const id = req.params.id;
      const user = await userService.updateUser(id, req.body);
      res.json(user);
    } catch (err) {
      logger.error(err);
      res.status(500).send({ message: 'Internal Server Error' });
    }
  },

  deleteUser: async (req, res) => {
    try {
      const id = req.params.id;
      await userService.deleteUser(id);
      res.json({ message: 'User deleted successfully' });
    } catch (err) {
      logger.error(err);
      res.status(500).send({ message: 'Internal Server Error' });
    }
  }
};
