import express from 'express';
import logger from './utils/logger';
import userRoute from './routes/user.route';
import userController from './controllers/user.controller';
import userModel from './models/user.model';
import userService from './services/user.service';

const app = express();

app.use(express.json());
app.use('/users', userRoute);

app.use((err, req, res, next) => {
  logger.error(err);
  res.status(500).send({ message: 'Internal Server Error' });
});

app.listen(3000, () => {
  logger.info('Server listening on port 3000');
});
