import express from 'express';
import { UserController } from './controllers/UserController';

const app = express();
const userController = new UserController(new UserRepository());

app.get('/users', userController.getAllUsers);
app.get('/users/:id', userController.getUserById);

app.listen(3000, () => {
  console.log('Server listening on port 3000');
});