import { Request, Response } from 'express';
import { UserRepository } from '../infrastructure/repositories/UserRepository';

export class UserController {
  private _userRepository: UserRepository;

  constructor(userRepository: UserRepository) {
    this._userRepository = userRepository;
  }

  async getAllUsers(req: Request, res: Response): Promise<void> {
    const users = await this._userRepository.getAllUsers();
    res.json(users);
  }

  async getUserById(req: Request, res: Response): Promise<void> {
    const id = req.params.id;
    const user = await this._userRepository.getUserById(id);
    if (user) {
      res.json(user);
    } else {
      res.status(404).json({ message: 'User not found' });
    }
  }
}