// Import dependencies
import { UserEntity } from './UserEntity';
import { UserRepository } from './UserRepository';

// Define the UserController
class UserController {
  private userRepository: UserRepository;

  constructor(userRepository: UserRepository) {
    this.userRepository = userRepository;
  }

  // Define a method to get all users
  public getAllUsers(req: Request, res: Response) {
    const users = this.userRepository.getAllUsers();
    res.json(users);
  }
}

// Export the UserController
export { UserController };
