// Import required modules
import { UserService } from './User';

// Define the UserService class
class UserService {
  async createUser(user: User) {
    // Create a new user
    const createdUser = await User.create(user);
    return createdUser;
  }

  async getUser(id: number) {
    // Get a user by ID
    const user = await User.findByPk(id);
    return user;
  }
}

// Export the UserService class
export default UserService;