# Clean Architecture Project

This project follows the clean architecture principles.

## Layers

### Entities
Entities represent the business domain.
### Use Cases
Use cases define the interactions between entities.
### Interface Adapters
Interface adapters handle communication with external systems.
### Frameworks and Drivers
Frameworks and drivers provide the underlying infrastructure.
### Infrastructure
Infrastructure represents the external dependencies.

## Dependencies

* No dependencies on frameworks or drivers in the business logic.
* No dependencies on entities in the interface adapters or frameworks/drivers.

## Testing

* Unit tests for entities and use cases.
* Integration tests for interface adapters and frameworks/drivers.
