// fileService.js

import logger from './utils/logger';

const fileService = {
  readFile: (filePath) => {
    try {
      const fileContent = require('fs').readFileSync(filePath, 'utf8');
      logger(`File ${filePath} read successfully`);
      return fileContent;
    } catch (error) {
      logger(`Error reading file ${filePath}: ${error.message}`);
      throw error;
    }
  },

  writeFile: (filePath, content) => {
    try {
      require('fs').writeFileSync(filePath, content);
      logger(`File ${filePath} written successfully`);
    } catch (error) {
      logger(`Error writing file ${filePath}: ${error.message}`);
      throw error;
    }
  }
};

export default fileService;
