// fileRoutes.js

import express from 'express';
import fileController from './controllers/fileController';

const router = express.Router();

router.get('/file/:filePath', (req, res) => {
  const filePath = req.params.filePath;
  const fileContent = fileController.getFileContent(filePath);
  res.send(fileContent);
});

router.post('/file/:filePath', (req, res) => {
  const filePath = req.params.filePath;
  const fileContent = req.body.content;
  fileController.saveFileContent(filePath, fileContent);
  res.send(`File ${filePath} saved successfully`);
});

export default router;
