// Import required modules
import { createExpressServer } from 'routing-controllers';
import { createConnection } from 'typeorm';

// Create TypeORM connection
createConnection({
  type: 'postgres',
  url: process.env.DATABASE_URL,
  synchronize: true,
  entities: [__dirname + '/**/*.entity{.ts,.js}'],
}).then(() => {
  // Create Express server
  const app = createExpressServer({
    controllers: [__dirname + '/**/*.controller{.ts,.js}'],
  });

  // Start the server
  const port = process.env.PORT || 3000;
  app.listen(port, () => {
    console.log(`Server started on port ${port}`);
  });
}).catch((error) => {
  console.error(error);
});