// Import required modules
import { Controller, Get, Post, Body } from 'routing-controllers';
import { User } from '../entities/User.entity';

// Define the UserController
@Controller()
export class UserController {
  @Get('/users')
  async getUsers(): Promise<User[]> {
    return await User.find();
  }

  @Post('/users')
  async createUser(@Body() user: User): Promise<User> {
    return await User.save(user);
  }
}