import { User } from '../entities/User';

export class LoginUseCase {
  private userRepository: UserRepository;

  constructor(userRepository: UserRepository) {
    this.userRepository = userRepository;
  }

  public async login(email: string, password: string): Promise<User> {
    const user = await this.userRepository.findByEmail(email);
    if (user && user.getPassword() === password) {
      return user;
    }
    return null;
  }
}