// Config.java
// Load secrets from properties file
public class Config {
    private static final String PROPERTIES_FILE = "application.properties";
    public static String getProperty(String key) {
        Properties properties = new Properties();
        try (InputStream inputStream = getClass().getClassLoader().getResourceAsStream(PROPERTIES_FILE)) {
            properties.load(inputStream);
            return properties.getProperty(key);
        } catch (IOException e) {
            // Handle exception
        }
        return null;
    }
}