import express, { Application } from 'express';
import { createServer } from 'http';
import { Server } from 'socket.io';

const app: Application = express();
const server = createServer(app);
const io = new Server(server);

app.use(express.json());

io.on('connection', (socket) => {
  console.log('Client connected');
});

server.listen(3000, () => {
  console.log('Server listening on port 3000');
});