# Clean Architecture Repository

This is a clean architecture repository with client and server directories.

## Structure

* `client`: Client-side code
* `server`: Server-side code

## Getting Started

1. Clone the repository
2. Install dependencies
3. Start the client and server

## Client

The client-side code is located in the `client` directory. It uses a RESTful API to communicate with the server.

## Server

The server-side code is located in the server directory. It uses a clean architecture to separate concerns.

## Commit Messages

* Use the present tense (e.g. "Add new feature")
* Use the imperative mood (e.g. "Fix bug")
* Keep messages concise and descriptive

## API Documentation

* Use Swagger or OpenAPI for API documentation
* Include API endpoints, request and response formats, and error handling
