# Clean Architecture Project

## Overview
This project follows the clean architecture principles.

## Structure
The project is divided into the following layers:

### Domain
Contains the business logic and entities.
### Data
Handles data access and storage.
### Infrastructure
Provides the necessary infrastructure for the application.
### Presentation
Handles user input and output.

## Dependencies
The project uses the following dependencies:

### Domain
* `@nestjs/common` for dependency injection.
* `@nestjs/core` for the application core.

### Data
* `typeorm` for database operations.

### Infrastructure
* `@nestjs/microservices` for microservices communication.

### Presentation
* `@nestjs/websockets` for real-time communication.

## Installation
To install the project dependencies, run the following command:

```bash
npm install
```

## Running the Application
To run the application, execute the following command:

```bash
npm run start
```
