import { User } from '../entities/User';

export class UserRepository {
  private _db: any;

  constructor(db: any) {
    this._db = db;
  }

  async findByUsername(username: string): Promise<User> {
    const result = await this._db.query('SELECT * FROM users WHERE username = ?', [username]);
    return result[0] ? new User(result[0].id, result[0].name) : null;
  }
}
