import express from 'express';
import { LoginUseCase } from '../useCases/LoginUseCase';
import { UserRepository } from '../interfaceAdapters/UserRepository';
import { Database } from '../frameworksAndDrivers/Database';

const app = express();
const loginUseCase = new LoginUseCase(new UserRepository(await Database.connect()));

app.post('/login', async (req, res) => {
  const user = await loginUseCase.execute(req.body.username, req.body.password);
  if (user) {
    res.json({ message: 'Logged in successfully' });
  } else {
    res.status(401).json({ message: 'Invalid credentials' });
  }
});

app.listen(3000, () => {
  console.log('Server listening on port 3000');
});
