# Clean Architecture Frontend Build

## Project Structure

### src/

#### components/

#### containers/

#### models/

#### services/

#### utils/

### index.js

### main.js

### styles/

### index.html

## Build Instructions

### Step 1: Install Dependencies

```bash
npm install
```

### Step 2: Build the Project

```bash
npm run build
```

### Step 3: Start the Development Server

```bash
npm run start
```

## Prebuilt dist/ Folder

You can skip steps 1-3 and use the prebuilt dist/ folder by running the following command:

```bash
npm run deploy
```

## Clean Architecture Overview

This project follows the clean architecture pattern, separating the application logic into layers:

### Presentation Layer (components/)

### Business Logic Layer (containers/)

### Data Access Layer (models/)

### Use Cases (services/)

### Utilities (utils/)

## Commit Messages

Follow the conventional commit message format:

```bash
feat: add new feature
fix: fix bug
docs: update documentation
style: update code style
refactor: refactor code
perf: improve performance
test: add test
chore: update dependencies
```

## License

This project is licensed under the MIT License.
