# Clean Architecture Project

## Overview
This is a production-ready project following clean architecture principles.

## Project Structure

### src/
#### main/
##### java/
##### resources/
#### test/
##### java/
##### resources/
#### utils/
#### domain/
#### infrastructure/
#### application/

### target/

### dist/

## Build Instructions

### Maven Build

1. Install Maven: `brew install maven` (on macOS) or `apt-get install maven` (on Linux)
2. Navigate to project root: `cd /path/to/project`
3. Run Maven build: `mvn clean package`
4. Build artifacts will be generated in `target/` directory

### Build and Run

1. Navigate to project root: `cd /path/to/project`
2. Run Java application: `java -jar target/project.jar`

## Clean Architecture

Clean architecture is a software design pattern that separates an application into layers, each with its own responsibility.

### Layers

1. **Entities**: Represent business domain objects
2. **Use Cases**: Define business rules and interactions
3. **Interface Adapters**: Handle input/output operations
4. **Frameworks and Drivers**: Interact with external systems
5. **Infrastructure**: Provide underlying system services
6. **Presentation**: Handle user interface and user experience

## Commit Messages

Follow standard commit message guidelines:

* Use imperative mood (e.g., 'Add feature X')
* Keep messages concise (max 50 characters)
* Use bullet points for multiple changes

## API Documentation

API documentation will be generated using JavaDoc.

## Testing

Unit tests will be written using JUnit.

## Code Quality

Code quality will be ensured using SonarQube.
