// UserController implementation
import { CreateUser } from '../domain/usecases/CreateUser';
import { UserRepository } from '../data/repositories/UserRepository';

class UserController {
  private userRepository: UserRepository;

  constructor(userRepository: UserRepository) {
    this.userRepository = userRepository;
  }

  async createUser(request: CreateUserRequest): Promise<CreateUserResponse> {
    const user = await this.userRepository.createUser(request);
    return { user };
  }
}
