// Import required modules
import { createServer } from 'http';
import { Server } from 'socket.io';

// Create an HTTP server
const httpServer = createServer();

// Create a Socket.IO server
const io = new Server(httpServer);

// Handle incoming connections
io.on('connection', (socket) => {
  console.log('Client connected');
});

// Start the server
httpServer.listen(3000, () => {
  console.log('Server listening on port 3000');
});