import { User } from '../domain/entities/User';
import { UserUseCase } from '../domain/usecases/UserUseCase';

class UserRepository {
  private userUseCase: UserUseCase;

  constructor(userUseCase: UserUseCase) {
    this.userUseCase = userUseCase;
  }

  getUsers(): Promise<User[]> {
    return this.userUseCase.getUsers();
  }
}

export { UserRepository };