# Clean Architecture Project

## Overview
This project follows the clean architecture principles to separate the application logic into layers.

## Project Structure

### Domain
The domain layer contains the business logic of the application.
### Infrastructure
The infrastructure layer contains the implementation details of the data storage and retrieval.
### Presentation
The presentation layer contains the user interface and API endpoints.

## Running the Application
To run the application, execute the following commands in the project root:

### Build
```bash
npm run build
```
### Start
```bash
npm run start
```

## API Endpoints
The API endpoints are located in the `src/presentation/api` directory.

## File Structure
```bash
src/
├── domain/
│   ├── entities/
│   ├── usecases/
│   └── interfaces/
├── infrastructure/
│   ├── repositories/
│   ├── data-sources/
│   └── interfaces/
├── presentation/
│   ├── controllers/
│   ├── routes/
│   └── api/
└── main.ts
```
