import { User } from '../entities/User';

export class LoginUseCase {
  private _userRepository: UserRepository;

  constructor(userRepository: UserRepository) {
    this._userRepository = userRepository;
  }

  async login(username: string, password: string): Promise<User> {
    const user = await this._userRepository.findByUsername(username);
    if (user && user.getPassword() === password) {
      return user;
    }
    return null;
  }
}