import { LoginUseCase } from '../useCases/LoginUseCase';

export class LoginForm {
  private _loginUseCase: LoginUseCase;

  constructor(loginUseCase: LoginUseCase) {
    this._loginUseCase = loginUseCase;
  }

  async handleSubmit(event: Event): Promise<void> {
    event.preventDefault();
    const username = document.getElementById('username')?.value;
    const password = document.getElementById('password')?.value;
    const user = await this._loginUseCase.login(username, password);
    if (user) {
      console.log(`Welcome, ${user.getName()}`);
    } else {
      console.error('Invalid username or password');
    }
  }
}