import React, { useState } from 'react';
import PricingTierService from '../services/PricingTierService';
import PricingTierUtils from '../utils/PricingTierUtils';

const PricingTier = () => {
  const [selectedPlan, setSelectedPlan] = useState(null);
  const [plans, setPlans] = useState([]);

  const handlePlanSelect = (plan) => {
    setSelectedPlan(plan);
  };

  const handlePlanAdd = () => {
    const newPlan = PricingTierUtils.generateNewPlan();
    setPlans([...plans, newPlan]);
  };

  const handlePlanRemove = (plan) => {
    setPlans(plans.filter((p) => p !== plan));
  };

  const handlePlanUpdate = (plan) => {
    const updatedPlans = plans.map((p) => (p === plan ? plan : p));
    setPlans(updatedPlans);
  };

  const plansData = PricingTierService.getPlans();

  return (
    <div>
      <h1>Pricing Tier Component</h1>
      <ul>
        {plansData.map((plan) => (
          <li key={plan.id}>
            <button onClick={() => handlePlanSelect(plan)}>{plan.name}</button>
          </li>
        ))}
      </ul>
      <button onClick={handlePlanAdd}>Add Plan</button>
      <button onClick={handlePlanRemove}>Remove Plan</button>
      <button onClick={handlePlanUpdate}>Update Plan</button>
      <p>Selected Plan: {selectedPlan ? selectedPlan.name : 'None'}</p>
    </div>
  );
};

export default PricingTier;