# Clean Architecture with Keyboard Navigation and ARIA Labels

## Overview

This project demonstrates a clean architecture with keyboard navigation and ARIA labels to ensure accessibility for users with disabilities.

## Dependencies

* Node.js (14.x or higher)
* npm (6.x or higher)

## Getting Started

1. Clone the repository: `git clone https://github.com/your-username/your-repo-name.git`
2. Install dependencies: `npm install`
3. Start the application: `npm start`

## Architecture

The project follows a clean architecture pattern, with the following layers:

* **Entities**: Represent the business domain, containing the core logic and data.
* **Use Cases**: Define the interactions between the user and the system, encapsulating the business logic.
* **Interface Adapters**: Handle the communication between the use cases and the external world, such as user input and output.
* **Frameworks and Drivers**: Interact with external systems, like databases and APIs.

## Accessibility Features

* **Keyboard Navigation**: The application is navigable using only the keyboard, ensuring users with mobility or dexterity impairments can interact with the page.
* **ARIA Labels**: Accessible Rich Internet Applications (ARIA) labels provide a clear and concise description of each element, enabling screen readers to convey the information to users with visual impairments.

## Code Structure

The code is organized into the following folders:

* **src**: Contains the application code, divided into the four layers mentioned above.
* **tests**: Holds the unit tests and integration tests for the application.
* **utils**: Provides utility functions for the application.

## Commit Messages

Follow the conventional commit message format:

* **feat**: A new feature.
* **fix**: A bug fix.
* **docs**: Changes to documentation.
* **style**: Changes to code style.
* **refactor**: Code refactoring.
* **perf**: Performance improvements.
* **test**: Adding missing tests.
* **chore**: Changes to build or auxiliary tools.
* **revert**: Reverts a previous commit.
