import { defineConfig } from 'vite';

export default defineConfig({
  root: 'src',
  base: '/react/',
  clearScreen: false,
  server: {
    port: 3000,
    host: '0.0.0.0',
    proxy: {
      '/api': 'http://localhost:3001'
    }
  },
  build: {
    outDir: 'dist/react',
    assetsDir: 'assets',
    rollupOptions: {
      output: {
        manualChunks: id => {
          if (id.includes('node_modules')) {
            return 'vendor';
          }
        }
      }
    }
  }
});