const fs = require('fs');
const path = require('path');

function inlineJs(html, jsCode) {
  const scriptTag = '<script>' + jsCode + '</script>';
  const headTag = '<head>' + scriptTag + '</head>';
  return html.replace('<head>', headTag);
}

function minifyJs(jsCode) {
  // Implement a simple JavaScript minifier here
  return jsCode.replace(/s+/g, '');
}

function inlineJsCode() {
  const html = fs.readFileSync('index.html', 'utf8');
  const jsCode = fs.readFileSync('script.js', 'utf8');
  const minifiedJsCode = minifyJs(jsCode);
  const inlinedHtml = inlineJs(html, minifiedJsCode);
  fs.writeFileSync('index.html', inlinedHtml);
}

inlineJsCode();