import React from 'react';
import './PricingTiers.css';

const PricingTiers = ({ plans, testimonials }) => {
  return (
    <div>
      <h1>Pricing Tiers</h1>
      <ul>
        {plans.map((plan, index) => (
          <li key={index}>
            <h2>{plan.name}</h2>
            <p>Price: ${plan.price}</p>
            <ul>
              {plan.features.map((feature, index) => (
                <li key={index}>{feature}</li>
              ))}
            </ul>
          </li>
        ))}
      </ul>
      <h1>Testimonials</h1>
      <ul>
        {testimonials.map((testimonial, index) => (
          <li key={index}>
            <h2>{testimonial.name}</h2>
            <p>{testimonial.quote}</p>
          </li>
        ))}
      </ul>
    </div>
  );
};

export default PricingTiers;
