import axe from 'axe-core';
import { JSDOM } from 'jsdom';

interface AccessibilityIssue {
  id: string;
  description: string;
  severity: string;
}

interface AccessibilityReport {
  issues: AccessibilityIssue[];
}

class AccessibilityValidator {
  private dom: JSDOM;

  constructor(private html: string) {
    this.dom = new JSDOM(html);
  }

  async validate(): Promise<AccessibilityReport> {
    const axeResults = await axe.run(this.dom.window.document);
    const issues: AccessibilityIssue[] = axeResults.violations.map((violation) => ({
      id: violation.id,
      description: violation.description,
      severity: violation.severity,
    }));
    return { issues };
  }
}

export default AccessibilityValidator;