# Clean Architecture Accessibility Validator

## Overview

This project uses accessibility tools to validate the accessibility and keyboard navigation of the UI.

## Architecture

The project follows the clean architecture pattern, separating the application logic into layers.

## Tools

* Accessibility tools: axe-core, eslint-plugin-jsx-a11y

## Getting Started

1. Clone the repository: `git clone https://github.com/your-username/accessibility-validator.git`
2. Install dependencies: `npm install`
3. Run the accessibility validator: `npm run validate`

## Example Use Case

To use the accessibility validator, simply run the `validate` script. The script will scan the UI and report any accessibility issues.

## Commit Message Guidelines

* Use the present tense (e.g. 'Add accessibility validator')
* Use the imperative mood (e.g. 'Fix bug')
* Keep the first line concise (e.g. 'Add accessibility validator')
* Use a blank line between the first line and the body of the commit message

## API Documentation

No API documentation is required for this project.

## License

This project is licensed under the MIT License.
