import { createServer } from 'http';
import { join } from 'path';
import { readFileSync } from 'fs';

const server = createServer((req, res) => {
  const filePath = join(__dirname, 'public', req.url);
  const fileContent = readFileSync(filePath, 'utf8');
  res.writeHead(200, { 'Content-Type': 'text/html' });
  res.end(fileContent);
});

const port = 8080;
server.listen(port, () => {
  console.log(`Server listening on port ${port}`);
});