import { Request, Response } from 'express';
import { User } from '../domain/entities/User';
import { UserRepository } from '../infrastructure/repositories/UserRepository';

export class UserController {
  private userRepository: UserRepository;

  constructor(userRepository: UserRepository) {
    this.userRepository = userRepository;
  }

  public async getUser(req: Request, res: Response): Promise<void> {
    const id = req.params.id;
    const user = await this.userRepository.findById(id);
    res.json(user);
  }
}
